/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing;

import frc.emul.util.swing.AALabel;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.Browser;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.version.Version;
import frc.emul.version.VersionChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class UIVersionChecker {
    private JDialog dlg;
    private boolean opened;
    private boolean canceled;
    private Boolean upToDate;
    private VersionChecker checker = new VersionChecker();

    public static void check(Window window, String string) {
        new UIVersionChecker().checkImpl(window, string);
    }

    private UIVersionChecker() {
    }

    private void checkImpl(Window window, final String string) {
        this.dlg = UIUtils.createDialog(window, "ParaJVE - Version Checking", true);
        new Thread("ParaJVE version checker's worker"){

            public void run() {
                Boolean bl = UIVersionChecker.this.checker.check(string);
                while (!UIVersionChecker.this.opened) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                UIVersionChecker.this.upToDate = bl;
                UIVersionChecker.this.dlg.setVisible(false);
            }
        }.start();
        JPanel jPanel = new JPanel(new FlowLayout(2));
        final JButton jButton = new JButton("Cancel");
        jPanel.add(jButton);
        UIUtils.registerEscapeButton(jButton, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIVersionChecker.this.canceled = true;
                UIVersionChecker.this.checker.abort();
                UIVersionChecker.this.dlg.dispose();
            }
        });
        this.dlg.setDefaultCloseOperation(0);
        this.dlg.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jButton.doClick(0);
            }

            public void windowOpened(WindowEvent windowEvent) {
                UIVersionChecker.this.opened = true;
            }
        });
        Container container = this.dlg.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        AALabel aALabel = new AALabel("<html>ParaJVE is checking for version updates.<br>This may take a few seconds...<br><br></html>");
        container.add((Component)aALabel, "Center");
        container.add((Component)jPanel, "South");
        UIUtils.setContainerBorder(container);
        this.dlg.pack();
        UIUtils.center(this.dlg, window, 0, 0);
        this.dlg.getRootPane().setDefaultButton(jButton);
        this.dlg.setResizable(false);
        this.dlg.setVisible(true);
        if (this.canceled) {
            System.out.println("Canceled");
            return;
        }
        container.remove(aALabel);
        jButton.setText("Close");
        JButton jButton2 = jButton;
        if (this.upToDate == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = this.checker.getError();
            stringBuffer.append("<html><b><font color=\"#C00000\">ParaJVE cannot check for the latest version available.</font></b><br><br>").append("<b>Error Cause</b> :<br>").append(string2 == null ? "No diagnosis available" : string2).append("</html>");
            AALabel aALabel2 = new AALabel(stringBuffer.toString());
            UIVersionChecker.setBevelBorder(aALabel2);
            container.add((Component)aALabel2, "Center");
        } else if (this.upToDate.booleanValue()) {
            AALabel aALabel3 = new AALabel("<html><center><b>You are running ParaJVE's latest version.</b><br><br><i>Maybe next time! </i><code>;)</code></center></html>");
            UIVersionChecker.setBevelBorder(aALabel3);
            container.add((Component)aALabel3, "Center");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = this.checker.getNewVersionFullNumber();
            final String string4 = this.checker.getNewVersionUpdateURL();
            String string5 = this.checker.getNewVersionReleaseDate();
            stringBuffer.append("<html><center><b><font size=+1>A new version of ParaJVE is available !</font></b>");
            stringBuffer.append("<br><br>");
            if (string4 != null) {
                stringBuffer.append("You can download it from the following URL :<br>");
                stringBuffer.append("<a href=\"").append(string4).append("\">").append(string4).append("</a><br><br>");
            }
            stringBuffer.append("<code>Your version : ").append(Version.sFULL);
            stringBuffer.append("<br>Last version : <b>").append(string3);
            stringBuffer.append("</b><br></code>");
            if (string5 != null) {
                stringBuffer.append("<br><i>(Release date : ").append(string5).append(")</i><br>");
            }
            AALabel aALabel4 = new AALabel(stringBuffer.append("<br></center></html>").toString());
            UIVersionChecker.setBevelBorder(aALabel4);
            container.add((Component)aALabel4, "Center");
            if (string4 != null) {
                JButton jButton3 = new JButton("Open Download Page...");
                jPanel.remove(jButton);
                jPanel.setLayout(new BorderLayout(0, 0));
                jPanel.add((Component)jButton3, "West");
                jPanel.add((Component)jButton, "East");
                jButton3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Browser.displayURL(string4, true);
                    }
                });
                jButton2 = jButton3;
            }
        }
        this.dlg.getRootPane().setDefaultButton(jButton2);
        this.dlg.setResizable(true);
        this.dlg.pack();
        UIUtils.center(this.dlg, window, 0, 0);
        this.dlg.setResizable(false);
        this.dlg.setVisible(true);
    }

    public static final void setBevelBorder(JComponent jComponent) {
        jComponent.setBorder(Borders.ETCHED_10);
    }
}

